/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.gui.preview.ElevatorPreviewRenderer;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;

public class ElevatorPreviewWidget
extends BaseWidget {
    private final Supplier<ControllerBlockEntity> elevatorEntity;
    private final Supplier<class_2338> previewSizeIncrease;
    private final Supplier<class_2338> previewOffset;
    private float yaw = 20.0f;
    private float pitch = 30.0f;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public ElevatorPreviewWidget(int x, int y, int width, int height, Supplier<ControllerBlockEntity> elevatorEntity, Supplier<class_2338> previewSizeIncrease, Supplier<class_2338> previewOffset) {
        super(x, y, width, height);
        this.elevatorEntity = elevatorEntity;
        this.previewSizeIncrease = previewSizeIncrease;
        this.previewOffset = previewOffset;
    }

    public class_2561 getNarrationMessage() {
        return null;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.dragging) {
            this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
            this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
        ControllerBlockEntity elevatorEntity = this.elevatorEntity.get();
        ElevatorGroup group = elevatorEntity.getGroup();
        class_2338 anchorPos = group.getCageAnchorBlockPos(elevatorEntity.method_11016().method_10264());
        WorldBlockCapture capture = new WorldBlockCapture(group.level);
        capture.putBlock(elevatorEntity.method_11016(), elevatorEntity.method_11016());
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    class_2338 pos = anchorPos.method_10069(x, y, z);
                    capture.putBlock(pos, pos);
                }
            }
        }
        class_238 cabinBox = new class_238((double)anchorPos.method_10263(), (double)anchorPos.method_10264(), (double)anchorPos.method_10260(), (double)(anchorPos.method_10263() + group.getCageSizeX()), (double)(anchorPos.method_10264() + group.getCageSizeY()), (double)(anchorPos.method_10260() + group.getCageSizeZ())).method_1014(0.1);
        class_2338 previewSizeIncrease = this.previewSizeIncrease.get();
        class_2338 previewOffset = this.previewOffset.get();
        class_238 previewBox = null;
        if (!previewSizeIncrease.equals((Object)class_2338.field_10980) || !previewOffset.equals((Object)class_2338.field_10980)) {
            int cabinWidth = group.getCageWidth() + previewSizeIncrease.method_10263();
            int cabinDepth = group.getCageDepth() + previewSizeIncrease.method_10260();
            int cabinHeight = group.getCageHeight() + previewSizeIncrease.method_10264();
            int sideOffset = group.getCageSideOffset() + previewOffset.method_10263();
            int depthOffset = group.getCageDepthOffset() + previewOffset.method_10260();
            int heightOffset = group.getCageHeightOffset() + previewOffset.method_10264();
            if (sideOffset > 2 + (group.facing == class_2350.field_11043 || group.facing == class_2350.field_11039 ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f))) {
                sideOffset = 2 + (group.facing == class_2350.field_11043 || group.facing == class_2350.field_11039 ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f));
            } else if (sideOffset < -2 - (group.facing == class_2350.field_11043 || group.facing == class_2350.field_11039 ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2)) {
                sideOffset = -2 - (group.facing == class_2350.field_11043 || group.facing == class_2350.field_11039 ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2);
            }
            if (heightOffset < -cabinHeight) {
                heightOffset = -cabinHeight;
            }
            int anchorX = 0;
            int anchorY = elevatorEntity.method_11016().method_10264();
            int anchorZ = 0;
            if (group.facing == class_2350.field_11043) {
                anchorX = group.x - cabinWidth / 2 - sideOffset;
                anchorZ = group.z - cabinDepth - depthOffset;
            } else if (group.facing == class_2350.field_11035) {
                anchorX = group.x - cabinWidth / 2 + sideOffset;
                anchorZ = group.z + 1 + depthOffset;
            } else if (group.facing == class_2350.field_11039) {
                anchorX = group.x - cabinDepth - depthOffset;
                anchorZ = group.z - cabinWidth / 2 + sideOffset;
            } else if (group.facing == class_2350.field_11034) {
                anchorX = group.x + 1 + depthOffset;
                anchorZ = group.z - cabinWidth / 2 - sideOffset;
            }
            previewBox = new class_238((double)anchorX, (double)(anchorY += heightOffset), (double)anchorZ, (double)(anchorX + (group.facing.method_10166() == class_2350.class_2351.field_11048 ? cabinDepth : cabinWidth)), (double)(anchorY + cabinHeight), (double)(anchorZ + (group.facing.method_10166() == class_2350.class_2351.field_11051 ? cabinDepth : cabinWidth))).method_1014(0.1);
        }
        ElevatorPreviewRenderer.renderPreview(capture, cabinBox, previewBox, (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, Math.min(this.width, this.height), this.yaw + group.facing.method_10144(), this.pitch, false);
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
            return true;
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }
}

